# Model Zoo

##  [CASIA-B](http://www.cbsr.ia.ac.cn/english/Gait%20Databases.asp)                                                                                          

|                                                                                          Model                                                                                          | `Rank@1.NM` | `Rank@1.BG` | `Rank@1.CL` | `mAP.NM` | `mAP.BG` | `mAP.CL` |                                            Configuration                                             | Input Size |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :---------: | :---------: | :---------: | :------: | :------: | :------: | :--------------------------------------------------------------------------------------------------: | :--------: |
|                                                                                        Baseline                                                                                         |    96.3     |    92.2     |    77.6     |   87.3   |   83.4   |   78.5   |                                            baseline.yaml                                             |   64x44    |
|                                                                [GaitSet(AAAI2019)](https://arxiv.org/pdf/1811.06186.pdf)                                                                | 95.8(95.0)  | 90.0(87.2)  | 75.4(70.4)  |   85.9   |   81.4   |   77.0   |                           [gaitset.yaml](../configs/gaitset/gaitset.yaml)                            |   64x44    |
|                                                   [GaitPart(CVPR2020)](http://home.ustc.edu.cn/~saihui/papers/cvpr2020_gaitpart.pdf)                                                    | 96.1(96.2)  | 90.7(91.5)  | 78.7(78.7)  |   84.8   |   81.1   |   75.5   |                          [gaitpart.yaml](../configs/gaitpart/gaitpart.yaml)                          |   64x44    |
|                                                        [GLN*(ECCV2020)](http://home.ustc.edu.cn/~saihui/papers/eccv2020_gln.pdf)                                                        | 96.4(95.6)  | 93.1(92.0)  | 81.0(77.2)  |   89.3   |   87.0   |   82.6   | [gln_phase1.yaml](../configs/gln/gln_phase1.yaml), [gln_phase2.yaml](../configs/gln/gln_phase2.yaml) |   128x88   |
| [GaitGL(ICCV2021)](https://openaccess.thecvf.com/content/ICCV2021/papers/Lin_Gait_Recognition_via_Effective_Global-Local_Feature_Representation_and_Local_Temporal_ICCV_2021_paper.pdf) | 97.4(97.4)  | 94.5(94.5)  | 83.8(83.6)  |   86.2   |   84.4   |   79.8   |                             [gaitgl.yaml](../configs/gaitgl/gaitgl.yaml)                             |   64x44    |
|                                                                      [GaitBase(CVPR2023)](https://arxiv.org/abs/2211.06597)                                                                       |    97.6     |    94.0     |    77.4     |    -     |    -     |    -     |                                                 [gaitbase_da_casiab.yaml](../configs/gaitbase/gaitbase_da_casiab.yaml)                                                   |   64x44    |

##  [CASIA-B*](http://www.cbsr.ia.ac.cn/english/Gait%20Databases.asp)

|                                                                                          Model                                                                                          | `Rank@1.NM` | `Rank@1.BG` | `Rank@1.CL` | Input modality  |                          Configuration                           |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :---------: | :---------: | :---------: | :-------------: | :--------------------------------------------------------------: |
|                                                                [GaitSet(AAAI2019)](https://arxiv.org/pdf/1811.06186.pdf)                                                                |    92.3     |    86.1     |    73.36    |   Silhouette    |         [gaitset.yaml](../configs/gaitset/gaitset.yaml)          |
|                                                   [GaitPart(CVPR2020)](http://home.ustc.edu.cn/~saihui/papers/cvpr2020_gaitpart.pdf)                                                    |    93.1     |    86.0     |    75.1     |   Silhouette    |        [gaitpart.yaml](../configs/gaitpart/gaitpart.yaml)        |
| [GaitGL(ICCV2021)](https://openaccess.thecvf.com/content/ICCV2021/papers/Lin_Gait_Recognition_via_Effective_Global-Local_Feature_Representation_and_Local_Temporal_ICCV_2021_paper.pdf) |    94.2     |    90.0     |    81.4     |   Silhouette    |           [gaitgl.yaml](../configs/gaitgl/gaitgl.yaml)           |
|                                                                 [GaitEdge(ECCV2022)](https://arxiv.org/abs/2203.03972)                                                                  |    97.9     |    96.1     |    86.4     | RGB, Silhouette | [phase2_gaitedge.yaml](../configs/gaitedge/phase2_gaitedge.yaml) |
|                                                                      [GaitBase(CVPR2023)](https://arxiv.org/abs/2211.06597)                                                                       |    96.5     |    91.5     |    78.0     |   Silhouette    |                                -                                 |

## [OUMVLP](http://www.am.sanken.osaka-u.ac.jp/BiometricDB/GaitMVLP.html)
|                                                                                          Model                                                                                          |  `Rank@1`  | `mAP` |                       Configuration                       | Input Size | Inference Time | Model Size |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :--------: | :---: | :-------------------------------------------------------: | :--------: | :------------: | :--------: |
|                                                                                        Baseline                                                                                         |    86.7    | 91.8  | [baseline.yaml](../configs/baseline/baseline_OUMVLP.yaml) |   64x44    |     1m13s      |   44.11M   |
|                                                                [GaitSet(AAAI2019)](https://arxiv.org/pdf/1811.06186.pdf)                                                                | 87.2(87.1) | 92.2  |  [gaitset.yaml](../configs/gaitset/gaitset_OUMVLP.yaml)   |   64x44    |     1m26s      |   6.31M    |
|                                                   [GaitPart(CVPR2020)](http://home.ustc.edu.cn/~saihui/papers/cvpr2020_gaitpart.pdf)                                                    | 88.6(88.7) | 93.3  | [gaitpart.yaml](../configs/gaitpart/gaitpart_OUMVLP.yaml) |   64x44    |     8m04s      |   3.78M    |
| [GaitGL(ICCV2021)](https://openaccess.thecvf.com/content/ICCV2021/papers/Lin_Gait_Recognition_via_Effective_Global-Local_Feature_Representation_and_Local_Temporal_ICCV_2021_paper.pdf) | 89.9(89.7) | 93.3  |    [gaitgl.yaml](../configs/gaitgl/gaitgl_OUMVLP.yaml)    |   64x44    |     5m23s      |   95.62M   |
|                                                                      [GaitBase(CVPR2023)](https://openaccess.thecvf.com/content/CVPR2023/papers/Fan_OpenGait_Revisiting_Gait_Recognition_Towards_Better_Practicality_CVPR_2023_paper.pdf)                                                                       |    90.8    |   -   |                             [gaitbase_oumvlp.yaml](../configs/gaitbase/gaitbase_oumvlp.yaml)                          | 64x44 |  -  |       -        |     -      |
|                                                                          [DeepGaitV2-3D](https://arxiv.org/pdf/2303.03301.pdf)                                                                           |   92.0   |                            -                           |  -  |   64x44    |       -        |     -      |

## [GREW](https://www.grew-benchmark.org)
|                                                                                              Model                                                                                              | `Rank@1` |                      Configuration                       | Input Size | Inference Time | Model Size |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :------: | :------------------------------------------------------: | :--------: | :------------: | :--------: |
|                                                                                            Baseline                                                                                             |   48.5   | [baseline.yaml](../configs/baseFline/baseline_GREW.yaml) |   64x44    |     2m23s      |   84.12M   |
|                                                                    [GaitSet(AAAI2019)](https://arxiv.org/pdf/1811.06186.pdf)                                                                    |   48.4   |   [gaitset.yaml](../configs/gaitset/gaitset_GREW.yaml)   |   64x44    |       -        |     -      |
|                                                       [GaitPart(CVPR2020)](http://home.ustc.edu.cn/~saihui/papers/cvpr2020_gaitpart.pdf)                                                        |   47.6   | [gaitpart.yaml](../configs/gaitpart/gaitpart_GREW.yaml)  |   64x44    |       -        |     -      |
|     [GaitGL(ICCV2021)](https://openaccess.thecvf.com/content/ICCV2021/papers/Lin_Gait_Recognition_via_Effective_Global-Local_Feature_Representation_and_Local_Temporal_ICCV_2021_paper.pdf)     |   41.5   |    [gaitgl.yaml](../configs/gaitgl/gaitgl_GREW.yaml)     |   64x44    |       -        |     -      |
| [GaitGL(BNNeck)(ICCV2021)](https://openaccess.thecvf.com/content/ICCV2021/papers/Lin_Gait_Recognition_via_Effective_Global-Local_Feature_Representation_and_Local_Temporal_ICCV_2021_paper.pdf) |   51.7   | [gaitgl.yaml](../configs/gaitgl/gaitgl_GREW_BNNeck.yaml) |   64x44    |       -        |     -      |
|                                                                          [GaitBase(CVPR2023)](https://openaccess.thecvf.com/content/CVPR2023/papers/Fan_OpenGait_Revisiting_Gait_Recognition_Towards_Better_Practicality_CVPR_2023_paper.pdf)                                                                           |   60.1   |                            [gaitbase_da_grew.yaml](../configs/gaitbase/gaitbase_da_grew.yaml)                             |   64x44    |       -        |     -      |
|                                                                          [DeepGaitV2-3D](https://arxiv.org/pdf/2303.03301.pdf)                                                                           |   79.4   |                            -                             |   64x44    |       -        |     -      |
|                                                                          [SwinGait(Transformer-based)](https://arxiv.org/pdf/2303.03301.pdf)                                                                           |   79.3   |                            -                             |   64x44    |       -        |     -      |


## [Gait3D](https://github.com/Gait3D/Gait3D-Benchmark)
|                                                                                          Model                                                                                          | `Rank@1` | Configuration | Input Size | Input modality |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :------: | :-----------: | :--------: | :--------:|
|                                                                Baseline                                                                |   46.9   |       [baseling_Gait3D.yaml](../configs/baseline/baseline_Gait3D.yaml)       |   64x44    | Silhouette |
|                                                                [GaitSet(AAAI2019)](https://arxiv.org/pdf/1811.06186.pdf)                                                                |   36.7   |       -       |   64x44    | Silhouette |
|                                                   [GaitPart(CVPR2020)](http://home.ustc.edu.cn/~saihui/papers/cvpr2020_gaitpart.pdf)                                                    |   28.2   |       -       |   64x44    | Silhouette |
| [GaitGL(ICCV2021)](https://openaccess.thecvf.com/content/ICCV2021/papers/Lin_Gait_Recognition_via_Effective_Global-Local_Feature_Representation_and_Local_Temporal_ICCV_2021_paper.pdf) |   29.7   |       -       |   64x44    | Silhouette |
|                                                                      [SMPLGait(CVPR 2022)](https://gait3d.github.io/)                                                                       |   48.3(46.3)   |       [smplgait.yaml](../configs/smplgait/smplgait.yaml)       |   64x44    | Silhouette + SMPL|
|                                                                      [GaitBase(CVPR2023)](https://openaccess.thecvf.com/content/CVPR2023/papers/Fan_OpenGait_Revisiting_Gait_Recognition_Towards_Better_Practicality_CVPR_2023_paper.pdf)                                                                       |   64.6   |       [gaitbase_da_gait3d.yaml](../configs/gaitbase/gaitbase_da_gait3d.yaml)       |   64x44    | Silhouette |
|                                                                          [DeepGaitV2-P3D](https://arxiv.org/pdf/2303.03301.pdf)                                                                           |   74.4   |                            -                             |   64x44    |       -        |     -      |
|                                                                          [SwinGait(Transformer-based)](https://arxiv.org/pdf/2303.03301.pdf)                                                                           |   75.0   |                            -                             |   64x44    |       -        |     -      |

##  [CASIA-E](https://www.scidb.cn/en/detail?dataSetId=57be0e918db743279baf44a38d013a06)

|                                                                                          Model                                                                                          | `Rank@1.NM` | `Rank@1.BG` | `Rank@1.CL` |       Input size|                    Configuration                           |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :---------: | :---------:| :----:  | :-------------: | :--------------------------------------------------------------: |
|    [GaitSet(AAAI2019)](https://arxiv.org/pdf/1811.06186.pdf)                    |    82.54     |    75.26     |    62.53         |                                64x44                                 | [gaitset_casiae.yaml](../configs/gaitset/gaitset_casiae.yaml)
|    [GaitPart(CVPR2020)](http://home.ustc.edu.cn/~saihui/papers/cvpr2020_gaitpart.pdf)                   |   82.92     |    74.36     |    60.48         |                                 64x44                                 | [gaitpart_casiae.yaml](../configs/gaitpart/gaitpart_casiae.yaml)
|     [GaitBase(CVPR2023)](https://openaccess.thecvf.com/content/CVPR2023/papers/Fan_OpenGait_Revisiting_Gait_Recognition_Towards_Better_Practicality_CVPR_2023_paper.pdf)                                       |    91.59     |    86.65     |    74.73         |                                64x44                                 | [gaitbase_casiae.yaml](../configs/gaitbase/gaitbase_casiae.yaml)

------------------------------------------

The results in the parentheses are mentioned in the papers. 

**Note**:
- All results exclude identical-view cases in CASIA-B(*) and OUMVLP.
- The shown result of GLN is implemented without compact block. 
- The mAP is calculated by the new evaluation protocol proposed in [A Comprehensive Study on the Evaluation of Silhouette-based Gait Recognition](https://ieeexplore.ieee.org/document/9928336).
